import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/data/model/invoice/invoice_history_response_model.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../data/controller/invoice/create_invoice_controller.dart';
import '../../../../data/repo/invoice/create_invoice_repo.dart';
import '../../../../data/services/api_service.dart';
import '../../../components/app-bar/custom_appbar.dart';
import '../../../components/custom_loader/custom_loader.dart';
import 'widget/invoice_details.dart';

class CreateInvoiceScreen extends StatefulWidget {
  const CreateInvoiceScreen({
    super.key,
    required this.paymentCharge,
  });
  final PaymentCharge paymentCharge;
  @override
  State<CreateInvoiceScreen> createState() => _CreateInvoiceScreenState();
}

class _CreateInvoiceScreenState extends State<CreateInvoiceScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(CreateInvoiceRepo(apiClient: Get.find()));
    final controller = Get.put(CreateInvoiceController(createInvoiceRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadData(widget.paymentCharge);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CreateInvoiceController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.colorWhite,
        appBar: CustomAppBar(
          title: MyStrings.createInvoice.tr,
          bgColor: MyColor.getAppBarColor(),
        ),
        body: const SingleChildScrollView(padding: EdgeInsets.symmetric(vertical: Dimensions.space20, horizontal: Dimensions.space15), child: InvoiceDetails()),
      ),
    );
  }
}
